/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.communi.suggestu.scena.core.client.models.IModelManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockModelBuilder;
import mod.chiselsandbits.client.model.baked.face.FaceRegion;
import mod.chiselsandbits.client.util.QuadGenerationUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModel
extends BaseBakedBlockModel {
    public static final ChiseledBlockBakedModel EMPTY = new ChiseledBlockBakedModel(BlockInformation.AIR, ChiselRenderType.SOLID, null, vector3d -> BlockInformation.AIR, 0L);
    private static final class_2350[] X_Faces = new class_2350[]{class_2350.field_11034, class_2350.field_11039};
    private static final class_2350[] Y_Faces = new class_2350[]{class_2350.field_11036, class_2350.field_11033};
    private static final class_2350[] Z_Faces = new class_2350[]{class_2350.field_11035, class_2350.field_11043};
    private final ChiselRenderType chiselRenderType;
    private class_777[] up;
    private class_777[] down;
    private class_777[] north;
    private class_777[] south;
    private class_777[] east;
    private class_777[] west;
    private class_777[] generic;

    private List<class_777> getList(class_2350 side) {
        if (side != null) {
            switch (side) {
                case field_11033: {
                    return this.asList(this.down);
                }
                case field_11034: {
                    return this.asList(this.east);
                }
                case field_11043: {
                    return this.asList(this.north);
                }
                case field_11035: {
                    return this.asList(this.south);
                }
                case field_11036: {
                    return this.asList(this.up);
                }
                case field_11039: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<class_777> asList(class_777[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public ChiseledBlockBakedModel(IBlockInformation state, ChiselRenderType layer, IAreaAccessor data, Function<class_243, IBlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        this.chiselRenderType = layer;
        class_1087 originalModel = null;
        if (state != null && !state.isAir()) {
            originalModel = class_310.method_1551().method_1541().method_3351().method_3335(state.getBlockState());
            originalModel = IModelManager.getInstance().adaptToPlatform(originalModel);
        }
        if (originalModel != null && data != null) {
            boolean shouldLayerRender;
            try (IProfilerSection ignoredLayerCheck = ProfilingManager.getInstance().withSection("check");){
                shouldLayerRender = layer.isRequiredForRendering(data);
            }
            if (shouldLayerRender) {
                ChiseledBlockModelBuilder builder = new ChiseledBlockModelBuilder();
                try (IProfilerSection ignoredFaceGeneration = ProfilingManager.getInstance().withSection("facegeneration");){
                    this.generateFaces(builder, data, neighborStateSupplier, primaryStateRenderSeed);
                }
                try (IProfilerSection ignoredFinalize = ProfilingManager.getInstance().withSection("finalize");){
                    this.up = builder.getSide(class_2350.field_11036);
                    this.down = builder.getSide(class_2350.field_11033);
                    this.east = builder.getSide(class_2350.field_11034);
                    this.west = builder.getSide(class_2350.field_11039);
                    this.north = builder.getSide(class_2350.field_11043);
                    this.south = builder.getSide(class_2350.field_11035);
                    this.generic = builder.getSide(null);
                }
            }
        }
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (class_2350 e : class_2350.values()) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    private void generateFaces(ChiseledBlockModelBuilder builder, IAreaAccessor accessor, Function<class_243, IBlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        ArrayList<List<FaceRegion>> resultingFaces = new ArrayList<List<FaceRegion>>();
        try (IProfilerSection ignoredFaceProcessing = ProfilingManager.getInstance().withSection("processing");){
            try (IProfilerSection ignoredXFaces = ProfilingManager.getInstance().withSection("x");){
                this.processFaces(accessor, resultingFaces, IPositionMutator.xzy(), X_Faces, class_243::method_10216, class_243::method_10215, neighborStateSupplier);
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("y");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zxy(), Y_Faces, class_243::method_10214, class_243::method_10215, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("z");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zyx(), Z_Faces, class_243::method_10215, class_243::method_10214, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
        }
        try (IProfilerSection ignoredFaceBuilding = ProfilingManager.getInstance().withSection("building");){
            try (IProfilerSection ignoredMerging = ProfilingManager.getInstance().withSection("merging");){
                for (List list : resultingFaces) {
                    this.mergeFaces(list);
                }
            }
            try (IProfilerSection ignoredQuadGeneration = ProfilingManager.getInstance().withSection("quadGeneration");){
                for (List list : resultingFaces) {
                    for (FaceRegion region : list) {
                        class_2350 cullDirection = region.getFace();
                        class_1160 from = region.minVector();
                        class_1160 to = region.maxVector();
                        List<class_777> target = builder.getList(null);
                        if (region.isEdge()) {
                            target = builder.getList(cullDirection);
                        }
                        QuadGenerationUtils.generateQuads(target, primaryStateRenderSeed, this.chiselRenderType.layer, region.getBlockInformation(), cullDirection, from, to);
                    }
                }
            }
        }
    }

    private void mergeFaces(List<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processFaces(final IAreaAccessor accessor, final List<List<FaceRegion>> resultingRegions, IPositionMutator analysisOrder, class_2350[] potentialDirections, final Function<class_243, Double> regionBuildingAxisValueExtractor, final Function<class_243, Double> faceBuildingAxisValueExtractor, final Function<class_243, IBlockInformation> neighborStateSupplier) {
        final ArrayList regions = Lists.newArrayList();
        final ICullTest test = this.chiselRenderType.getTest();
        for (final class_2350 facing : potentialDirections) {
            final FaceBuildingState state = new FaceBuildingState();
            accessor.forEachWithPositionMutator(analysisOrder, new Consumer<IStateEntryInfo>(){

                @Override
                public void accept(IStateEntryInfo stateEntryInfo) {
                    if (!ChiseledBlockBakedModel.this.chiselRenderType.isRequiredForRendering(stateEntryInfo)) {
                        return;
                    }
                    if (state.getRegionBuildingAxisValue() != ((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        if (!regions.isEmpty()) {
                            resultingRegions.add(Lists.newArrayList((Iterable)regions));
                        }
                        regions.clear();
                        state.setCurrentRegion(null);
                    }
                    state.setRegionBuildingAxisValue((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    if (state.getFaceBuildingAxisValue() != ((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        state.setCurrentRegion(null);
                    }
                    state.setFaceBuildingAxisValue((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    Optional<FaceRegion> potentialRegionData = ChiseledBlockBakedModel.this.buildFaceRegion(accessor, facing, stateEntryInfo, test, neighborStateSupplier);
                    if (potentialRegionData.isEmpty()) {
                        state.setCurrentRegion(null);
                        return;
                    }
                    if (state.getCurrentRegion() != null && state.getCurrentRegion().extend(potentialRegionData.get())) {
                        return;
                    }
                    state.setCurrentRegion(potentialRegionData.get());
                    regions.add(potentialRegionData.get());
                }
            });
            if (!regions.isEmpty()) {
                resultingRegions.add(Lists.newArrayList((Iterable)regions));
            }
            regions.clear();
        }
    }

    private Optional<FaceRegion> buildFaceRegion(IAreaAccessor blob, class_2350 facing, IStateEntryInfo target, ICullTest test, Function<class_243, IBlockInformation> neighborStateSupplier) {
        return Optional.of(target).filter(stateEntryInfo -> {
            class_243 faceOffSet = class_243.method_24954((class_2382)facing.method_10163()).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            class_243 offsetTarget = stateEntryInfo.getStartPoint().method_1019(faceOffSet);
            if (!blob.isInside(offsetTarget)) {
                IBlockInformation externalNeighborState = (IBlockInformation)neighborStateSupplier.apply(offsetTarget);
                return Optional.of(externalNeighborState).map(neighborState -> test.isVisible((IStateEntryInfo)stateEntryInfo, (IBlockInformation)neighborState, facing)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
            }
            return blob.getInAreaTarget(offsetTarget).map(IStateEntryInfo::getBlockInformation).map(neighborState -> test.isVisible((IStateEntryInfo)stateEntryInfo, (IBlockInformation)neighborState, facing)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
        }).map(stateEntryInfo -> {
            class_243 faceOffSet = class_243.method_24954((class_2382)facing.method_10163()).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            class_243 offsetTarget = stateEntryInfo.getStartPoint().method_1019(faceOffSet);
            return FaceRegion.createFrom3DObjectWithFacing(stateEntryInfo.getStartPoint(), stateEntryInfo.getEndPoint(), facing, stateEntryInfo.getBlockInformation(), !blob.isInside(offsetTarget));
        });
    }

    @NotNull
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand) {
        return this.getList(side);
    }

    public boolean method_24304() {
        return true;
    }

    @NotNull
    public class_1058 method_4711() {
        return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
    }

    private static final class FaceBuildingState {
        private double regionBuildingAxis = -1.0;
        private double faceBuildingAxis = -1.0;
        private FaceRegion currentRegion;

        private FaceBuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public FaceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(FaceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}

