/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_156;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Vector2f {
    public static final Codec<Vector2f> CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> class_156.method_33141((List)floats, (int)2).map(sizedFloats -> new Vector2f(((Float)sizedFloats.get(0)).floatValue(), ((Float)sizedFloats.get(1)).floatValue())), vector -> ImmutableList.of((Object)Float.valueOf(vector.x), (Object)Float.valueOf(vector.y)));
    public static Vector2f XN = new Vector2f(-1.0f, 0.0f);
    public static Vector2f XP = new Vector2f(1.0f, 0.0f);
    public static Vector2f YN = new Vector2f(0.0f, -1.0f);
    public static Vector2f YP = new Vector2f(0.0f, 1.0f);
    public static Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    private float x;
    private float y;

    public Vector2f() {
    }

    public Vector2f(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
    }

    public Vector2f(float a, float b) {
        this.x = a;
        this.y = b;
    }

    public Vector2f(double a, double b) {
        this.x = (float)a;
        this.y = (float)b;
    }

    public Vector2f(class_1162 pVector) {
        this(pVector.method_4953(), pVector.method_4956());
    }

    public Vector2f(class_1160 pVector) {
        this(pVector.method_4943(), pVector.method_4945());
    }

    public Vector2f(class_243 pVector) {
        this((float)pVector.field_1352, (float)pVector.field_1351);
    }

    public Vector2f(class_241 pVector) {
        this(pVector.field_1343, pVector.field_1342);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther != null && this.getClass() == pOther.getClass()) {
            Vector2f Vector2f2 = (Vector2f)pOther;
            if (Float.compare(Vector2f2.x, this.x) != 0) {
                return false;
            }
            return Float.compare(Vector2f2.y, this.y) != 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        return 31 * i + Float.floatToIntBits(this.y);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public void mul(float pMultiplier) {
        this.x *= pMultiplier;
        this.y *= pMultiplier;
    }

    public void mul(Vector2f pMultiplier) {
        this.x *= pMultiplier.x;
        this.y *= pMultiplier.y;
    }

    public void mul(float pMx, float pMy) {
        this.x *= pMx;
        this.y *= pMy;
    }

    public void div(float pMultiplier) {
        this.x /= pMultiplier;
        this.y /= pMultiplier;
    }

    public void div(Vector2f pMultiplier) {
        this.x /= pMultiplier.x;
        this.y /= pMultiplier.y;
    }

    public void div(float pMx, float pMy) {
        this.x /= pMx;
        this.y /= pMy;
    }

    public void clamp(Vector2f pMin, Vector2f pMax) {
        this.x = class_3532.method_15363((float)this.x, (float)pMin.x(), (float)pMax.x());
        this.y = class_3532.method_15363((float)this.y, (float)pMin.x(), (float)pMax.y());
    }

    public void clamp(float pMin, float pMax) {
        this.x = class_3532.method_15363((float)this.x, (float)pMin, (float)pMax);
        this.y = class_3532.method_15363((float)this.y, (float)pMin, (float)pMax);
    }

    public void set(float pX, float pY) {
        this.x = pX;
        this.y = pY;
    }

    public void load(Vector2f pOther) {
        this.x = pOther.x;
        this.y = pOther.y;
    }

    public void add(float pX, float pY) {
        this.x += pX;
        this.y += pY;
    }

    public void add(Vector2f pOther) {
        this.x += pOther.x;
        this.y += pOther.y;
    }

    public void sub(Vector2f pOther) {
        this.x -= pOther.x;
        this.y -= pOther.y;
    }

    public float dot(Vector2f pOther) {
        return this.x * pOther.x + this.y * pOther.y;
    }

    public boolean normalize() {
        float f = this.x * this.x + this.y * this.y;
        if ((double)f < 1.0E-5) {
            return false;
        }
        float f1 = class_3532.method_22858((float)f);
        this.x *= f1;
        this.y *= f1;
        return true;
    }

    public void lerp(Vector2f pVector, float pDelta) {
        float f = 1.0f - pDelta;
        this.x = this.x * f + pVector.x * pDelta;
        this.y = this.y * f + pVector.y * pDelta;
    }

    public Vector2f copy() {
        return new Vector2f(this.x, this.y);
    }

    public void map(Float2FloatFunction pMapper) {
        this.x = pMapper.get(this.x);
        this.y = pMapper.get(this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }
}

