/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_5458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSectionUtils {
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    private static final Logger LOGGER = LogManager.getLogger();

    private ChunkSectionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ChunkSectionUtils. This is a utility class");
    }

    public static class_2520 serializeNBT(class_2826 chunkSection) {
        return (class_2520)BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_12265()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static class_2487 serializeNBTCompressed(class_2826 chunkSection) {
        class_2520 outputTag = (class_2520)BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_12265()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        if (!(outputTag instanceof class_2487)) {
            throw new IllegalStateException("Serialized into incompatible tag type: " + outputTag.method_23258().method_23261());
        }
        class_2487 compressedSectionData = (class_2487)outputTag;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)compressedSectionData, (OutputStream)outputStream);
            byte[] compressedData = outputStream.toByteArray();
            class_2487 gzipCompressedTag = new class_2487();
            gzipCompressedTag.method_10556("isCompressed", true);
            gzipCompressedTag.method_10570("compressedData", compressedData);
            return gzipCompressedTag;
        }
        catch (Exception e) {
            LOGGER.error("Failed to compress chiseled block data.", (Throwable)e);
            return compressedSectionData;
        }
    }

    public static void deserializeNBT(class_2826 chunkSection, class_2520 tag) {
        if (!(tag instanceof class_2487)) {
            return;
        }
        class_2487 compoundTag = (class_2487)tag;
        if (compoundTag.method_33133()) {
            return;
        }
        if (compoundTag.method_10573("isCompressed", 1) && compoundTag.method_10577("isCompressed") && compoundTag.method_10573("compressedData", 7)) {
            try {
                byte[] compressedData = compoundTag.method_10547("compressedData");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedData);
                class_2487 decompressedCompoundTag = class_2507.method_10629((InputStream)inputStream);
                chunkSection.field_12878 = (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)decompressedCompoundTag).promotePartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                chunkSection.method_12253();
                return;
            }
            catch (Exception e) {
                LOGGER.error("Failed to decompress chiseled block entity data. Resetting data.");
                ChunkSectionUtils.fillFromBottom(chunkSection, class_2246.field_10124.method_9564(), StateEntrySize.current().getBitsPerBlock());
                chunkSection.method_12253();
                return;
            }
        }
        chunkSection.field_12878 = (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag).promotePartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        chunkSection.method_12253();
    }

    public static class_2826 rotate90Degrees(class_2826 source, class_2350.class_2351 axis, int rotationCount) {
        if (rotationCount == 0) {
            return source;
        }
        class_243 centerVector = new class_243(7.5, 7.5, 7.5);
        class_2826 target = new class_2826(0, class_5458.field_25933);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_243 workingVector = new class_243((double)x, (double)y, (double)z);
                    class_243 rotatedVector = workingVector.method_1020(centerVector);
                    for (int i = 0; i < rotationCount; ++i) {
                        rotatedVector = VectorUtils.rotate90Degrees(rotatedVector, axis);
                    }
                    class_2338 sourcePos = new class_2338(workingVector);
                    class_243 offsetPos = rotatedVector.method_1019(centerVector).method_18805(1000.0, 1000.0, 1000.0);
                    class_2338 targetPos = new class_2338(new class_243((double)Math.round(offsetPos.method_10216()), (double)Math.round(offsetPos.method_10214()), (double)Math.round(offsetPos.method_10215())).method_18805(0.001, 0.001, 0.001));
                    target.method_16675(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260(), source.method_12254(sourcePos.method_10263(), sourcePos.method_10264(), sourcePos.method_10260()));
                }
            }
        }
        return target;
    }

    public static class_2826 cloneSection(class_2826 lazyChunkSection) {
        class_2826 clone = new class_2826(0, class_5458.field_25933);
        ChunkSectionUtils.deserializeNBT(clone, ChunkSectionUtils.serializeNBT(lazyChunkSection));
        return clone;
    }

    public static void fillFromBottom(class_2826 chunkSection, class_2680 blockState, int amount) {
        int loopCount = Math.max(0, Math.min(amount, StateEntrySize.current().getBitsPerBlock()));
        if (loopCount == 0) {
            return;
        }
        int count = 0;
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    chunkSection.method_16675(x, y, z, blockState);
                    if (++count != loopCount) continue;
                    return;
                }
            }
        }
    }

    public static class_2826 mirror(class_2826 lazyChunkSection, class_2350.class_2351 axis) {
        class_2826 result = new class_2826(0, class_5458.field_25933);
        for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    class_2680 blockState = lazyChunkSection.method_12254(x, y, z);
                    int mirroredX = axis == class_2350.class_2351.field_11048 ? StateEntrySize.current().getBitsPerBlockSide() - x - 1 : x;
                    int mirroredY = axis == class_2350.class_2351.field_11052 ? StateEntrySize.current().getBitsPerBlockSide() - y - 1 : y;
                    int mirroredZ = axis == class_2350.class_2351.field_11051 ? StateEntrySize.current().getBitsPerBlockSide() - z - 1 : z;
                    result.method_12256(mirroredX, mirroredY, mirroredZ, blockState, false);
                }
            }
        }
        return result;
    }
}

